import java.io.*;
import java.awt.*;
import java.awt.event.*;
import java.net.*;

public class ipprint extends Frame implements WindowListener, ActionListener, Runnable {
   private Button go = new Button("Print");
   private Label no1 = new Label(" the file");
//   private TextField name = new TextField("C:\\SYSTEM.1ST", 30);
   private TextField name = new TextField("", 30);
   private Button fname = new Button("Browse");
   private Label no2 = new Label(" to the IP address");
//   private TextField ip = new TextField("209.0.131.6", 15);
   private TextField ip = new TextField("library1", 15);
   private Label no3 = new Label(" on port");
   private TextField port = new TextField("9100", 5);
//   private TextField port = new TextField("80", 5);
   private Label no4 = new Label(" using a");
   private TextField bufsize = new TextField("32768", 5);
//   private TextField bufsize = new TextField("512", 5);
   private Label no5 = new Label(" byte buffer, or maybe just");
   private Button stop = new Button("stop printing");
   private Label no6 = new Label(", or better yet,");
   private Button dup = new Button("duplicate the window.");
   private Label no7 = new Label(" Maybe you'll");
   private Button clr = new Button("clear the console.");
   private Label status;
   private TextArea taConsole;
   private static final Font fntDefault = new Font("Arial", Font.BOLD, 16);

   private boolean printing = false;
   private String fnamee, ipp;
   private int portt, buffer;
   private boolean shouldstop = false;
   private int runlevel = 0;

   public void setIpAddress(String x) {ip.setText(x);}

   public static void main(String args[]) {
       Frame f = new Frame("Console");
       f.setFont(fntDefault);
       f.setBackground(Color.lightGray);
       TextArea console = new TextArea();
       f.setLayout(new BorderLayout());
       f.add("Center", console);
       f.show();
       f.setSize(600,400);
       f.setLocation(0,200);

       f.invalidate();
       f.validate();

       OutputStream dos = new DocumentOutputStream(console);
       console.setEditable(false);
       PrintStream ps = new PrintStream(dos);

       System.setOut(ps);
       System.setErr(ps);

       ipprint ippy = new ipprint(console, 0);
       f.addWindowListener(ippy);
   }

   public ipprint(TextArea ta, int rl) {
       super("IP Print 1.21");

       setBackground(Color.lightGray);
       setLayout(new BorderLayout());
       setFont(fntDefault);

       setVisible(true);
       setSize(new Dimension(600, 200));
       addWindowListener(this);

       //invalidate();

       taConsole = ta;
       runlevel = rl;

       Panel p = new Panel();
       p.setLayout(new FlowLayout());
       go.setActionCommand("go");
       go.addActionListener(this);
       p.add(go);
       p.add(no1);
       p.add(name);
       p.add(fname);
       fname.setActionCommand("browse");
       fname.addActionListener(this);
       p.add(no2);
       p.add(ip);
       p.add(no3);
       p.add(port);
       p.add(no4);
       p.add(bufsize);
       p.add(no5);
       stop.setActionCommand("stop");
       stop.addActionListener(this);
       stop.setEnabled(false);
       p.add(stop);
       p.add(no6);
       dup.setActionCommand("duplicate");
       dup.addActionListener(this);
       p.add(dup);
       p.add(no7);
       clr.setActionCommand("clear");
       clr.addActionListener(this);
       p.add(clr);

       status = new Label("Ready.");
//       status.setEditable(false);

       add("Center", p);
       add("South", status);

       invalidate();
       validate();
   }

   //WindowListener
   public void windowActivated(WindowEvent e) {}
   public void windowDeactivated(WindowEvent e) {}
   public void windowIconified(WindowEvent e) {}
   public void windowDeiconified(WindowEvent e) {}
   public void windowOpened(WindowEvent e) {}
   public void windowClosed(WindowEvent e) {}
   public void windowClosing(WindowEvent e) {
       if(runlevel == 0) {System.exit(0);} else {dispose();}
   }

   private void setstatus(String x) {
       status.setText(x);
   }

   private void setStatusLn(String x) {
       status.setText(x);
       System.out.println(x);
   }

   private void setStatus(String x) {
       status.setText(x);
       System.out.print(x);
   }

   public void actionPerformed(ActionEvent e) {
   	String x = e.getActionCommand();
		if(x.equals("browse")) {
           FileDialog fd = new FileDialog(this, "Choose a file to print...", FileDialog.LOAD);
           fd.setFile(name.getText());
           fd.show();
           if(fd.getFile() != null)
       	    name.setText(fd.getDirectory()+fd.getFile());
       } else if (x.equals("go")) {
           setStatusLn("Sending request...");
           if(printing) return;
           printing = true;
           fnamee = name.getText();
           ipp = procIp(ip.getText());
           portt = Integer.parseInt(port.getText());
           buffer = Integer.parseInt(bufsize.getText());
           Thread t = new Thread(this);
           t.start();
       } else if (x.equals("stop")) {
           setStatusLn("Sending stop request...");
           shouldstop = true;
       } else if (x.equals("duplicate")) {
           ipprint ippy = new ipprint(taConsole, runlevel+1);
           Point f = getLocation();
           ippy.setLocation(f.x+3, f.y+25);

           switch(runlevel+1) {
               case 0: ippy.setIpAddress("library1"); break;
               case 1: ippy.setIpAddress("yearbook"); break;
               case 2: ippy.setIpAddress("mmr"); break;
               case 3: ippy.setIpAddress("color"); break;
               case 4: ippy.setIpAddress("langlab"); break;
               default: ippy.setIpAddress("<specify ip address>"); break;
           }
       } else if (x.equals("clear")) {
           taConsole.setText("");
       }
   }

   private static String translateDNS(String addr) {
       String newaddr = addr.toLowerCase();

       if(newaddr.equals("library1")) {
           return "172.20.9.199";
//       } else if(newaddr.equals("library2")) {
//           return "172.20.9.207";
       } else if(newaddr.equals("mmr")) {
           return "172.20.9.204";
       } else if(newaddr.equals("langlab")) {
           return "172.20.9.82";
       } else if(newaddr.equals("color")) {
           return "172.20.9.223";
       } else if(newaddr.equals("beanery")) {
           return "172.20.8.204";
       } else if(newaddr.equals("yearbook")) {
           return "172.20.9.91";
       } else if(newaddr.equals("loopback")) {
           return "127.0.0.1";
       } else {
           return addr;
       }
   }

   private String procIp(String x) {
       return translateDNS(x);
   }

   public void run() {
       Socket s = null;
       OutputStream osData = null;
       InputStream fis = null;
     try {
       go.setEnabled(false);
       name.setEnabled(false);
       fname.setEnabled(false);
       ip.setEnabled(false);
       port.setEnabled(false);
       bufsize.setEnabled(false);
       stop.setEnabled(true);

       setStatusLn("Sending "+fnamee+" to "+ipp+":"+portt+"...");
       try {
           boolean gotConnection = false;
           int count = 1;
           do {
               setStatusLn("Attempting connection ("+count+")...");
               count++;
               if(shouldstop) {shouldstop = false; return;}
               try {
       	        s = new Socket(ipp, portt);
                   gotConnection = true;
               } catch (java.net.ConnectException ep) {
                   gotConnection = false;
                   try { Thread.sleep(500); } catch (InterruptedException ez) {}
               }
           } while( (gotConnection == false) || (s == null) );
           setStatusLn("Got one!");
           osData = s.getOutputStream();
           fis = new FileInputStream(fnamee);

           long fsize = 1;
           {
               File f = new File(fnamee);
               fsize = f.length();
           }

           System.out.print("Bytes Sent: ");

           byte data[] = new byte[buffer];
           int cnt; int total = 0; int counter = 1;
           while ((cnt = fis.read(data)) != -1) {
               total += cnt;
               System.out.print(total+"...");
               setstatus("Bytes sent: "+total+" ("+((int)((float)total/fsize*100))+"%)...");
               if((counter % 5) == 0) System.out.println("");
//               setStatusLn("Sent "+total+" bytes...");
               if(shouldstop) { shouldstop = false; return; }
               osData.write(data, 0, cnt);
               counter++;
           }
           System.out.println("");
       } catch (Exception ex) {ex.printStackTrace();}

       setStatusLn("File has been printed.");
       MessageBox mb = new MessageBox(this, "Done printing", "I have sent the file to the IP address.");
       mb.show();
     } finally {
       try {fis.close();} catch (Exception e) {}
       try {osData.close();} catch (Exception e) {}
       try {s.close();} catch (Exception e) {}
       go.setEnabled(true);
       name.setEnabled(true);
       fname.setEnabled(true);
       ip.setEnabled(true);
       port.setEnabled(true);
       bufsize.setEnabled(true);
       stop.setEnabled(false);
       printing = false;
       setStatusLn("Finished.");
       System.out.println("----------------------");
       setstatus("Ready.");
     }
   }
}