/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JWindow;
import javax.swing.border.LineBorder;

public class ImageLoadStatusManager
extends JWindow
implements ImageObserver,
LoadStatusManager {
    Image splashIm;
    JLabel s;
    JLabel l;
    JProgressBar p;
    int iCalls = 0;

    public ImageLoadStatusManager(Frame frame, Image image) {
        super(frame);
        this.splashIm = image;
        ((Component)this).setBackground(Color.white);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.l = new JLabel("Creating Property Panels...", 0);
        this.l.setForeground(Color.red);
        this.s = new JLabel(new ImageIcon(image));
        container.add("Center", this.s);
        this.s.add(this.l);
        this.l.setBounds(20, 300, 230, 20);
        this.p = new JProgressBar(0, 100);
        this.s.add(this.p);
        this.p.setBounds(20, 324, 230, 20);
        this.p.setValue(33);
        this.p.setStringPainted(true);
        this.p.setForeground(Color.red);
        this.p.setBackground(Color.black);
        this.p.setBorder(new LineBorder(Color.white, 1));
        this.resetSize();
    }

    public ImageLoadStatusManager(Image image) {
        this(new JFrame(), image);
    }

    public void dispose() {
        super.dispose();
    }

    public static ImageLoadStatusManager getImageLoadStatusManager(Frame frame, String string) {
        MediaTracker mediaTracker = new MediaTracker(frame);
        Image image = Toolkit.getDefaultToolkit().getImage(string);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {}
        return new ImageLoadStatusManager(frame, image);
    }

    public static ImageLoadStatusManager getImageLoadStatusManager(String string) {
        return ImageLoadStatusManager.getImageLoadStatusManager(new JFrame(), string);
    }

    public int getMaximum() {
        return this.p.getMaximum();
    }

    public int getProgressNum() {
        return this.p.getValue();
    }

    public String getProgressText() {
        return this.l.getText();
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        this.resetSize();
        return true;
    }

    private void resetSize() {
        if (this.splashIm.getWidth(this) < 0) {
            return;
        }
        Dimension dimension = new Dimension(this.splashIm.getWidth(this) + 2, this.splashIm.getHeight(this) + 2);
        ((Component)this).setSize(dimension);
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension3 = this.getSize();
        ((Component)this).setLocation((dimension2.width - dimension3.width) / 2, (dimension2.height - dimension3.height) / 2);
        this.setVisible(true);
    }

    public void setMaximum(int n) {
        this.p.setMaximum(n);
    }

    public void setProgress(String string) {
        this.setVisible(true);
        this.doLayout();
        this.p.setValue(this.iCalls++);
        this.l.setText(string);
    }

    public void setProgress(String string, int n) {
        this.setVisible(true);
        this.doLayout();
        this.iCalls = n;
        this.p.setValue(n);
        this.l.setText(string);
    }

    public void setProgressNum(int n) {
        this.setVisible(true);
        this.doLayout();
        this.iCalls = n;
        this.p.setValue(n);
    }

    public void setProgressText(String string) {
        this.setVisible(true);
        this.doLayout();
        this.l.setText(string);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
    }
}

