import java.io.*;
import java.net.URL;

class IOManager {
   private boolean isApp;
   private String sCodeBase;

   public IOManager(ConfigManager cfgmgr) {
       isApp = cfgmgr.isApp();
       sCodeBase = cfgmgr.getCodeBase();
   }

   public InputStream getInputStream(String string) throws IOException{
   	InputStream res = null;
   	try {
   		res = getClass().getResourceAsStream(string);
       } catch (SecurityException e) {}

       if(res != null) return res;

       if(isApp) {
           return new FileInputStream(string);
       } else {
           return new URL(sCodeBase + string).openStream();
       }
   }

   public byte[] getFile(String fname) throws IOException {
       InputStream is = getInputStream(fname);
       byte[] b = new byte[is.available()];
       is.read(b);
       return b;
   }
}