import java.awt.*;
import BaseGraph;
import java.util.*;

public class TempGraph extends BaseGraph {
   public final int n = 256;

   public TempGraph (int idx, PropertyPanelScript pps, PropertyPanelManager pp, ConfigManager cfgmgr, DatabaseManager dbmgr, StatusBar sb, String unts, float inv, String c){
       super(idx, pps, pp, cfgmgr, dbmgr, sb, unts, inv, c);
       selectedColor = Color.magenta;
       curveColor = Color.black;
       labelColor = Color.black;
       yGranularity = 100;
       axisColor = Color.darkGray;
       locatorCaption = Color.black;
   }

   protected void paintBackground(Graphics g){
       Dimension d = getSize();

/*
       d.height / 256 = step value for the green
       start w/ rgb(ff,g,00) and run to rgb(ff,g,00) where
           rect
           g += step
       end loop
*/
       double step = (double)d.height / n, yy=0.0;
       Color c = new Color(0xff,0xff,0);
       g.setColor(c);

       for(int gg=256;gg>0;gg-=(256/n)){
           g.fillRect(0,(int)Math.round(yy),d.width,(int)Math.round(step)+1);

           yy += step;
           c = new Color(0xff,gg-1,0);
           g.setColor(c);

       }
   }

   protected void paintGrid(Graphics g){
       return;
   }
/*   public void setColorScheme(String s) {
       if(s.equals("Monochrome")){
           setBackground(Color.white);
           labelColor = Color.black;
           gridColor = new Color(208, 208, 208);
           locatorColor = Color.darkGray;
           locatorCaption = Color.black;
           axisColor = Color.black;
           selectedColor = Color.black;
           curveColor = Color.darkGray;
       } else { //this is "standard" scheme!
           setBackground(Color.black);
           labelColor = Color.black;
           gridColor = darkGreen;
           locatorColor = lightBlue;
           locatorCaption = Color.black;
           axisColor = Color.darkGray;
           selectedColor = Color.magenta;
           curveColor = Color.black;
       }
   }*/
}
