/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ClassReader
implements ElementInfo,
Runnable {
    public static final int ACC_PUBLIC = 1;
    public static final int ACC_PRIVATE = 2;
    public static final int ACC_PROTECTED = 4;
    public static final int ACC_STATIC = 8;
    public static final int ACC_FINAL = 16;
    public static final int ACC_SYNCHRONIZED = 32;
    public static final int ACC_THREADSAFE = 64;
    public static final int ACC_TRANSIENT = 128;
    public static final int ACC_NATIVE = 256;
    public static final int ACC_INTERFACE = 512;
    public static final int ACC_ABSTRACT = 1024;
    private String fname;
    private int[] magic;
    private int[] version;
    private int constant_pool_count;
    private int access_flags;
    private int this_class;
    private int super_class;
    private InterfaceInfo interfaces;
    private FieldInfo fields;
    private MethodInfo methods;
    private AttributeInfo attributes;
    private ConstantPoolInfo constants;
    private JTree tree;
    private StatusKeeper stats;
    private StatusKeeper stats2;
    private Thread th;

    public void run() {
        this.stats.initProgressBar();
        this.stats.showProgressBar();
        this.stats.setMax(16);
        this.ReadClass();
        this.stats.hideProgressBar();
        this.stats.hideWindow();
    }

    private final void ReadClass() throws ClassFormatError {
        try {
            this.stats.setStatus("Opening class \"" + this.fname + "\"...");
            FileInputStream fileInputStream = new FileInputStream(this.fname);
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(fileInputStream));
            this.stats.setProgressText("Verifying class file integrity...", 1);
            this.magic[0] = dataInputStream.readUnsignedShort();
            this.magic[1] = dataInputStream.readUnsignedShort();
            if (this.magic[0] != 51966 || this.magic[1] != 47806) {
                throw new ClassFormatError("The file you selected is not a valid Java class file.");
            }
            this.stats.setProgressText("Reading class version...", 2);
            this.version[0] = dataInputStream.readUnsignedShort();
            this.version[1] = dataInputStream.readUnsignedShort();
            this.stats.setProgressText("Reading constant pool...", 3);
            this.constants = new ConstantPoolInfo(dataInputStream, this.stats2);
            this.stats.setProgressText("Reading class info...", 4);
            this.access_flags = dataInputStream.readUnsignedShort();
            this.this_class = dataInputStream.readUnsignedShort();
            this.super_class = dataInputStream.readUnsignedShort();
            this.stats.setProgressText("Reading Interface info...", 5);
            this.interfaces = new InterfaceInfo(this.constants, dataInputStream, this.stats2);
            this.stats.setProgressText("Reading Field pool...", 6);
            this.fields = new FieldInfo(this.constants, dataInputStream, this.stats2);
            this.stats.setProgressText("Reading & Disassembling Methods...", 7);
            this.methods = new MethodInfo(this.constants, dataInputStream, this.stats2);
            this.stats.setProgressText("Reading class attributes...", 8);
            this.attributes = new AttributeInfo(this.constants, dataInputStream);
            this.stats.setProgressText("Formatting class info...", 9);
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Class: " + this.fname);
            defaultMutableTreeNode.add(this.Describe());
            this.stats.setProgressText("Formatting constant pool...", 10);
            defaultMutableTreeNode.add(this.constants.Describe());
            this.stats.setProgressText("Formatting Interface info...", 11);
            defaultMutableTreeNode.add(this.interfaces.Describe());
            this.stats.setProgressText("Formatting Field pool...", 12);
            defaultMutableTreeNode.add(this.fields.Describe());
            this.stats.setProgressText("Formatting Method disassembly...", 13);
            defaultMutableTreeNode.add(this.methods.Describe());
            this.stats.setProgressText("Formatting class attributes...", 14);
            defaultMutableTreeNode.add(this.attributes.Describe());
            this.stats.setProgressText("Changing tree contents...", 15);
            DefaultTreeModel defaultTreeModel = new DefaultTreeModel(defaultMutableTreeNode);
            this.tree.setModel(defaultTreeModel);
            this.stats.setProgressText("Class disassembly complete.", 16);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public DefaultMutableTreeNode Describe() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("General Class Info");
        defaultMutableTreeNode.add(new DefaultMutableTreeNode("Magic Number: 0x" + Integer.toString(this.magic[0], 16) + Integer.toString(this.magic[1], 16)));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode("Class Version: " + Integer.toString(this.version[1], 10) + '.' + Integer.toString(this.version[0], 10)));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode("Access Specifiers: " + ClassReader.listAccessFlags(this.access_flags)));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode("this: " + this.constants.describe(this.this_class)));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode("parent: " + this.constants.describe(this.super_class)));
        return defaultMutableTreeNode;
    }

    public static String listAccessFlags(int n) {
        StringBuffer stringBuffer = new StringBuffer("");
        if ((n & 1) != 0) {
            stringBuffer.append("PUBLIC ");
        }
        if ((n & 2) != 0) {
            stringBuffer.append("PRIVATE ");
        }
        if ((n & 4) != 0) {
            stringBuffer.append("PROTECTED ");
        }
        if ((n & 8) != 0) {
            stringBuffer.append("STATIC ");
        }
        if ((n & 0x10) != 0) {
            stringBuffer.append("FINAL ");
        }
        if ((n & 0x20) != 0) {
            stringBuffer.append("SYNCHRONIZED ");
        }
        if ((n & 0x40) != 0) {
            stringBuffer.append("THREADSAFE ");
        }
        if ((n & 0x80) != 0) {
            stringBuffer.append("TRANSIENT ");
        }
        if ((n & 0x100) != 0) {
            stringBuffer.append("NATIVE ");
        }
        if ((n & 0x200) != 0) {
            stringBuffer.append("INTERFACE ");
        }
        if ((n & 0x400) != 0) {
            stringBuffer.append("ABSTRACT ");
        }
        if (stringBuffer.length() < 5) {
            stringBuffer.append("DEFAULT");
        }
        return stringBuffer.toString();
    }

    private final /* synthetic */ void this() {
        this.fname = "";
        this.magic = new int[2];
        this.version = new int[2];
    }

    public ClassReader(String string, JTree jTree, StatusKeeper statusKeeper, StatusKeeper statusKeeper2) {
        this.this();
        this.fname = string;
        this.tree = jTree;
        this.stats = statusKeeper;
        this.stats2 = statusKeeper2;
        this.th = new Thread(this);
        this.th.setPriority(3);
        this.th.start();
    }
}

