import java.io.*;
import javax.swing.tree.*;

class MethodInfo implements ElementInfo {
	int count;
	ConstantPoolInfo constants;
	MethodItem methods[];
	StatusKeeper stats;

	public MethodInfo(ConstantPoolInfo c, DataInputStream is, StatusKeeper y)
	{
		try
		{
			stats = y;
			constants = c;
			count = is.readUnsignedShort();
			if ( count != 0 )
			{
				methods = new MethodItem[count];
				for ( int x = 0; x < count; x++ )
					methods[x] = new MethodItem(c, is, x, stats);
			}
		}
		catch (IOException ioe)
		{
			System.out.println("" + ioe);
		}
	}


	public DefaultMutableTreeNode Describe() {
		stats.initProgressBar();
		stats.setMax(count);

		DefaultMutableTreeNode result = new DefaultMutableTreeNode("Methods: "+count+" items.");

		for ( int x = 0; x < count; x++ )
			result.add(methods[x].Describe());

		return result;
	}
}

class MethodItem implements ElementInfo {
	int access_flags;
	int name_index;
	String name;
	int signature_index;
	AttributeInfo attributes;
	ConstantPoolInfo constants;
	int num;
	StatusKeeper stats;

	public MethodItem(ConstantPoolInfo c, DataInputStream is, int x, StatusKeeper y)
	{
		try
		{
			stats = y;
			num = x;
			constants = c;
			access_flags = is.readUnsignedShort();
			name_index = is.readUnsignedShort();
			name = c.getUtf8(name_index);
			signature_index = is.readUnsignedShort();
			attributes = new AttributeInfo(c, is);
		}
		catch (IOException ioe)
		{
			System.out.println("" + ioe);
		}
	}

	public DefaultMutableTreeNode Describe() {
		stats.setProgressText("Processing method \""+name+"\"...", num);
		DefaultMutableTreeNode result = new DefaultMutableTreeNode(name);
		result.add(new DefaultMutableTreeNode(constants.getUtf8(signature_index)));
		result.add(new DefaultMutableTreeNode(ClassReader.listAccessFlags(access_flags)));
		result.add(attributes.Describe());
		return result;
	}
}
