package jrand.parser;

public class CFGToken {
	private String name;
	private int type;

	public final static int NODE = 1;
	public final static int STRING = 2;
	public final static int CHAR = 3;
	public final static int OR = 4;
	public final static int EQUALS = 5;
	public final static int ENDRULE = 6;

	public CFGToken(int typ, String name) {
		this.name = name;
		type = typ;
	}

	public CFGToken(int typ) {
		type = typ;
	}

	public String getName() {return name;}
	public int getType() {return type;}

	public String toString() {
		switch(type) {
			case NODE: return "<"+name+">";
			case STRING:
			case CHAR:
				return "\""+name+"\"";
			case OR: return "|";
			case EQUALS: return "=";
			case ENDRULE: return "<EOL>\n";
			default: return "?";
		}
	}
}
